/**
 * i-net software provides programming examples for illustration only, without warranty
 * either expressed or implied, including, but not limited to, the implied warranties
 * of merchantability and/or fitness for a particular purpose. This programming example
 * assumes that you are familiar with the programming language being demonstrated and
 * the tools used to create and debug procedures. i-net software support professionals
 * can help explain the functionality of a particular procedure, but they will not modify
 * these examples to provide added functionality or construct procedures to meet your
 * specific needs.
 *
 * Copyright © 1999-2026 i-net software GmbH, Berlin, Germany.
**/
package jdbc;

import java.io.File;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;

import com.inet.report.Datasource;
import com.inet.report.Engine;

/**
 * This sample demonstrates how you can set external database connections that will be used to fetch the report data
 * instead of the database connection that was specified at design time.
 */
public class EngineSetConnection {

    /**
     * The main method to show the example
     * @param args not needed
     */
    public static void main( String[] args ) {
        try {
            // Create a new engine, e.g. for PDF export
            Engine engine = new Engine( Engine.EXPORT_PDF );

            // Set the report file
            engine.setReportFile( "samples/sample.rpt" );
            // engine.setReportFile("file:c:/MyReports/report1.rpt");

            // Set values for needed parameters
            //engine.setPassword("...");
            //engine.setPrompt("...","...");

            // Create the JDBC connection for the main report
            // Set a timeout for login and query
            DriverManager.setLoginTimeout( 10 );
            // Open a connection to the database
            Connection con = DriverManager.getConnection( "url" );

            // Set the connection for the main report
            Datasource ds = engine.getDatabaseTables().getDatasource( 0 );
            ds.setConnection( con );

            // Set the connection for the existing sub-report(s)
            int subReportCount = engine.getSubReportCount();
            for( int i = 0; i < subReportCount; i++ ) {
                Datasource dsSub = engine.getSubReport( i ).getDatabaseTables().getDatasource( 0 );
                dsSub.setConnection( DriverManager.getConnection( "url" ) );
            }

            // Start the report execution
            engine.execute();

            // Save executed report in a PDF file
            File pdfFile = new File( "sample.pdf" );
            // File pdfFile = new File("C:/MyExports/sample.pdf");
            FileOutputStream fos = new FileOutputStream( pdfFile );
            for( int i = 1; i <= engine.getPageCount(); i++ ) {
                fos.write( engine.getPageData( i ) );
            }
            fos.close();
        } catch( Throwable t ) {
            t.printStackTrace();
        }
        System.exit( 0 );
    }
}
